<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Library Model
 * @Module      Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Model_Library extends Model_Base {
    
    public function create($owner,$type = null,$file_name=null) {
        $file_name  = empty($file_name) && !empty($type) ? $type : $file_name; 
        $type       = empty($file_name) && !empty($type) ? 'image' : $type;
        
        $insert = $this->insert('media_libraries')->set('type','image')->set('file_name',$file_name)
                ->execute();
        if (!empty($insert[1])) {
            Model::factory('history')->insert_history(array(
                    'source_id' => $insert[0],
                    'table'     => 'media_libraries',
                    'type'      => 'upload',
                    'owner'     => $owner
                ));
        }
        return true;
    }
    
    public function delete_library($id = 0) {
        return $this->delete('media_libraries')->where('id = '.$id)->execute();
    }    
    
    public function get_library($id=null) {
        if (empty($id)) return null;
        
        return Setup::join_histories('media_libraries','ml')
                    ->where('ml.id = '.$id)
                    ->execute()->current();
    }    
    
    /**
     * @params boolean  query exection
     */
    public function media_position($execution = true) {
       $get = Setup::join_histories('media_positions','mp');
       return $execution === true ? $get->execute() : $get;                         
    }    
    
    public function get_media_position($id) {
        return $this->media_position(false)
                    ->where('mp.id = '.$id)
                    ->execute()
                    ->current();
    }
}

?>