<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    News Category Form
 * @Module      News
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

?>

<?php   
    echo Config::check_message();
    
    if ($form_action != 'save' && empty($data->id)) {
        echo '<label class="no_data">'.__('no_data').'</label>';   
        return;    
    } else {
        $form = Form::init(array('multilang' => false))
                // Parsing form data                
                ->set_data($data)
                
                // Attribute form section
                ->attribute('class','frm-general frm-cms')
                ->attribute('id','frm_base')->attribute('class','frm_base no_validation')
                ->action($site->bs_cms.'news/category/'.$form_action);
        
        if (isset($data->id)) {
                // Add input to form
             $form                
                ->add('hidden')
                    ->set_name('news_category_id')
                    ->set_value(!isset($data->id) ? null : $data->id)
                    ->order(27)    
                ->add('hidden')
                    ->set_name('previous_ordering')
                    ->set_value(!isset($data->ordering) ? null : $data->ordering)
                    ->order(28);
        }
        
        echo $form
            ->add('submit')->set_value('')->order(100)->set_label('')
            ->build('news::news_category');
        
           
        
    }
?>

<script>
    $(document).ready(function(){
        <?php if ($transaction == 'create') { ?>
        $('.title').keyup(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#permalink-'+lang_id).val(cute_url($(this).val()));
        });
        $('.title').blur(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#permalink-'+lang_id).val(cute_url($(this).val()));
        });
        <?php } ?>
        $('form#frm_base').validate({
            onkeyup: false,
            errorPlacement  : function(error, element) {
                $(element).closest('.input-form').find('.error_field').after(error); 
            }
        });
        
        $('.title').each(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#title-'+lang_id).rules("add",{
                minlength : 3,
                check_availablity : {
                    "table" : "news_categories",
                    "field" : "label",
                    "job"   : "<?php echo $transaction;?>",
                    "prev"  : "<?php echo empty($data->label) ? '' : $data->label; ?>"
                }
            });
        });
        
        $('.permalink').each(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#permalink-'+lang_id).rules("add",{
                minlength : 3,
                check_availablity : {
                    "table" : "news_categories",
                    "field" : "permalink",
                    "job"   : "<?php echo $transaction;?>",
                    "prev"  : "<?php echo empty($data->permalink) ? '' : $data->permalink; ?>"
                }
            });
        });
    });
</script>