<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Setup Magic Class
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Setup {
    /**
     * @param mixed string $key or array ($key=>$data);
     */
    public function set($key,$value = NULL) {
        if (is_array($key) && count($key) > 0) 
            foreach ($key as $new_key=>$value) $this->$new_key = $value; 
        elseif(!is_array($key))
            $this->$key = $value;
            
        return $this;
    }
    
    public function get($key) {
        return !empty($this->$key) ? $this->$key : $key;
    }
    
    public static function join_histories($table_name,$table_alias = null,array $extends_select = array()) {
        $model_base = Model::factory('base');
        
        $sub_update  = $model_base->select('u.source_id','u.table',array(DB::expr('MAX(u.`time`)'),'last_updated'))
                            ->from(array('histories','u'))
                            ->where("u.type != created")
                            ->and_where("u.type != create")
                            ->and_where("u.type != install")
                            ->group_by('u.table')
                            ->group_by('u.id')
                            ->order_by('u.time','desc')
                            ->object();
        
        $extends_select = is_array($table_alias) ? $table_alias : $extends_select;    
        $table_alias  = empty($table_alias)|| is_array($table_alias) ? $table_name : $table_alias;
        $select_field = array("$table_alias.*",array('c.time','time_created'),'last_updated');
        $select_field = !empty($extends_select) ? array_merge($select_field,$extends_select) : $select_field;
                
        $object = $model_base->select_array($select_field)
                    ->from(array($table_name,$table_alias))
                    ->join(array('histories','c'),'LEFT')
                    ->on("c.source_id = $table_alias.id")
                    ->on("c.table = $table_name",true)
                    //->on("c.type = create",true)
                    ->join(array($sub_update,'uu'),'left')
                    ->on("uu.source_id = $table_alias.id")
                    ->on("uu.table = $table_name",true)
                    ->where_open()
                    ->where("c.type = create")
                    ->or_where("c.type = install")
                    ->where_close()            
                    ->group_by("$table_alias.id");
        
                    
        return $object;
    }
    
    public static function join_histories_2($table_name,$table_alias = null,array $extends_select = array()) {
        $model_base = Model::factory('base');
        
        $extends_select = is_array($table_alias) ? $table_alias : $extends_select;    
        $table_alias  = empty($table_alias)|| is_array($table_alias) ? $table_name : $table_alias;
        $select_field = array("$table_alias.*");
        $select_field = !empty($extends_select) ? array_merge($select_field,$extends_select) : $select_field;
                
        $object = $model_base->select_array($select_field)
                    ->from(array($table_name,$table_alias))
                    ->group_by("$table_alias.id");
        
                    
        return $object;
    }
}