<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    News Read Controller
 * @Module      News
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Site_News_Read extends Controller_Space_Site {
    protected $site;
    protected $permalink;
    
    public function before() {  
       parent::before();     
       $this->site->menu->id = Model::factory('menu')->menu_id('news');       
       $this->site->menu->active = 'news-event';
       $this->permalink = $this->request->param('permalink');
       
       $this->banner = Widget::$instance->load('page-banner')
                                ->set('table','site_menus')
                                ->set('source_id',$this->site->menu->id)
                                ->set('position', 'Page Banner');
        
       $this->site->menu->title = Model::factory('news')->get_parent_menu_title('news-event');
               
       $this->left_content = View::factory('general/left-content')
                ->set('news_event_left', true)
                ->set('category_active', 'news')
                ->set('email_widget', true);
    }
    
    public function action_index(){
        
        $get_all_published_news = Model::factory('news')->get_all_published_news();
        $right_content = View::factory('html/site/news/right-content')
                ->set('news', $get_all_published_news)
                ->set('section', 'listing');
       
        $this->set('title', 'News | ' . $this->site->meta->title)
             ->meta('title', 'News | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    public function action_read() {                                  
        $news = Model::factory('news')->get_by('field','permalink',$this->permalink);
        $right_content = View::factory('html/site/news/right-content')
                ->set('news', $news)
                ->set('section', 'read');
       
        $this->set('title', 'News | '. $this->site->meta->title)
             ->meta('title', strip_tags($news->current()->intro))
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    public function after() {        
        $this->render();
        parent::after();
    }

} // End Welcome
