<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    Welcome Controller
 * @Module      ~
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Site_Page_Pages extends Controller_Space_Site {
    protected $site;
    
    public function before() {  
        parent::before();
        $this->layout = 'two-column';
        
        $this->menu_active_parent = Model::factory('page')->get_parent_permalink($this->param1);
        $this->site->menu->active = $this->menu_active_parent;
        $this->site->menu->id = Model::factory('menu')->menu_id($this->menu_active_parent); 
        $this->banner = Widget::$instance->load('page-banner')
                                ->set('table','site_menus')
                                ->set('source_id',$this->site->menu->id)
                                ->set('position', 'Page Banner');
        
        $this->site->menu->title = Model::factory('page')->get_parent_menu_title($this->param1);
    }
    
    public function action_view() {
                
        $left_content = View::factory('general/left-content')
                ->set('left_menu_pages_widget', true)
                ->set('email_widget', true);
        
        $current_page = Model::factory('page')->get_current_page($this->param1);
        $current_parent_id = $current_page->current()->parent_id;
        $site_menu_id = $current_page->current()->site_menu_id;
                
        $page_detail = ($current_parent_id==0)
                        ?$this->top_page($site_menu_id)
                        :$current_page;
        
        foreach ($page_detail as $data) {
            $page_title = $data->page_title;
            $description = $data->description;
        }
                
        $right_content = View::factory('html/site/page/right-content')
                ->set('page_detail', $page_detail)
                ->set('menu_active_parent', $this->menu_active_parent);
	       
        $this->set('title','About | ' . $page_title)
             ->meta('title','About | ' . $page_title)
            ->meta('description','About | ' . substr(strip_tags($description), 0, 160).'...')
             ->set('banner',$this->banner)
             ->set('left_content', $left_content)
             ->set('right_content', $right_content)
             ->render();
	}
        
        /*
         * 
         */
        private function top_page($parent_id=0){            
            return Model::factory('page')->get_top_page($parent_id);
        }

} // End Welcome
