<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana <deni@webarq.com>
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Class Site Template
 * @Module      Templanation
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Space_Site extends Controller_Space_Html {
    protected $site;
    
    /**
     * @var boolean decide whether you want to use predefined system constructor
     */
    protected $predefined = false;
    
    public function before() { 
        $this->template = 'space/site';
        
        parent::before();
               
        // Cookie of site
        $cookie = Cookie::get('site',NULL);                
        if (empty($cookie))
            Cookie::set('site','site::'.$this->site->salt.'::'.$this->site->session->regenerate());
            
        $this->site->cookie = $cookie;
        
        // Identify current session
        $this->site->user->identify($cookie);
        
        // Objectify site menu
        $this->site->menu = new stdClass();
                
    }
    
    public function after() {
        
        // Default CSS
        $this->styles(array(            
            $this->site->themes_css.'general/style.css'    => 'screen,projection',
        ));
        
        // Default JS
        $this->scripts(array(            
            $this->site->themes_js.'plugin/jPages.min.js',
            $this->site->system_js.'plugin/jquery.validate.js',
            $this->site->themes_js.'plugin/slides-home.js',
            $this->site->themes_js.'plugin/accordionMenu.js',
            $this->site->themes_js.'plugin/jcarousellite.js',
            $this->site->themes_js.'jquery-1.6.2.min.js',
        ));        
        
        parent::after();
    }
    
} 