<?php
defined( 'SYSPATH' ) or die( 'No direct script access.' ) ;

/**
 * Kohana_Math_Quantity Class 
 * @author Wulung Pambuko M.Kom.
 * @copyright (c) 2012 PT. Web Architect Technology
 * @license http://kohanaframework.org/license
 */
class Kohana_Math_Quantity { 
    
    /**
     * The depth 
     * @access protected
     * @var int  
     */
    protected $depth = 0 ;
    
    /** 
     * The expression 
     * @access protected 
     * @var string  
     */
    protected $expression = null ;
    
    /** 
     * The operand limit 
     * @access protected 
     * @var int  
     */
    protected $operand_limit = 10 ;
    
    /** 
     * The operand number limit 
     * @access protected 
     * @var int  
     */
    protected $operand_num_limit = 3 ;
    
    /** 
     * Constructor 
     * @param string $expression The expression 
     * @param int $depth The depth 
     * @param int $operand_limit The operand limit 
     * @param int $operand_num_limit The operand number limit 
     * @access public 
     */
    public function __construct( 
            $expression = null, 
            $depth = null, 
            $operand_limit = null, 
            $operand_num_limit = null ) 
    {
        /*** Set the expression ***/
        if( $expression )
        {
            $this->expression = substr( $expression, 0 ) ;
        }
        
        /*** Set the depth ***/
        if( $depth )
        {
            $this->depth = $depth ;
        }
        
        /*** Set the operand limit ***/
        if( $operand_limit )
        {
            $this->operand_limit = $operand_limit ;
        }
        
        /*** Set the operand number limit ***/
        if( $operand_num_limit )
        {
            $this->operand_num_limit = $operand_num_limit ;
        }
    }
    
    /** 
     * Get or set the depth also (if depth is set)
     * @param $depth The depth 
     * @return int The depth  
     */
    public function depth( $depth = null ) 
    {
        if( $depth ) 
        {
            $this->depth = $depth ;
        }
        
        return $this->depth ;
    }
    
    /** 
     * Get or set the expression also (if expression is set)
     * @return string The expression 
     */
    public function expression( $expression = null ) 
    {
        if( $expression ) 
        {
            $this->expression = substr( $expression, 0 ) ;
        }
        
        return $this->expression ;
    }
    
    /** 
     * Generate 
     * @return string The expression 
     */
    public function expression_generate() {
        $this->expression = '' ;
        
        /* @var $operand_count int */
        $operand_count = 0 ;
        while( $operand_count < $this->operand_num_limit - 1 )
        {
            $this->expression .= mt_rand( 0, $this->operand_limit ) ;
            $this->expression .= Math_Operator::random() ;
            
            $operand_count++ ;
        }
        $this->expression .= mt_rand( 0, $this->operand_limit ) ;
        
        return $this->expression ;
    }
    
    /** 
     * Instance
     * @return Math_Operator
     */
    public static function instance() {
        $class = get_called_class() ;
        
        return new $class() ;
    }
    
    /** 
     * Destructor  
     */
    public function __destruct() 
    {
        
    }
    
}
?>
