<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Ajax System Class Controller
 * @Module      Base
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_CEO_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();        
        $this->model_ceo = Model::factory('ceo');
    }
    
    public function action_delete_ceo() {  
        $return = false;
        
        if ($this->post) {
            if (!empty($this->site->user->profile->is_admin)) {
                $return = $this->model_ceo->row_delete($this->param1);                        
            }
        }
        $this->ajax = json_encode($return);
    }
    
    public function action_activate_ceo() {  
        $return = false;
        
        if ($this->post) {
            if (!empty($this->site->user->profile->is_admin)) {
                $return = $this->model_ceo->row_activate($this->param1);                        
            }
        }
        $this->ajax = json_encode($return);
    }
    
    public function action_deactivate_ceo() {  
        $return = false;
        
        if ($this->post) {
            if (!empty($this->site->user->profile->is_admin)) {
                $return = $this->model_ceo->row_deactivate($this->param1);                        
            }
        }
        $this->ajax = json_encode($return);
    }

    public function action_image_upload() {  
        $return = false;
        if ($this->post && !empty($this->post['directory'])) {
            if (!empty($this->site->user->profile->is_admin)) {
                $file = $_FILES['image_upload'];
				$renamed	=	helper_tool::file_name_beautification($file['name']);
                $name 			= 	$this->site->session->id().'_ii_'.$renamed;
                echo $renamed;
                $temp_dir = empty($this->post['temp_dir']) 
                            ? ImageLibrary::$temp_dir 
                            : $this->post['temp_dir'];
                            
                //Check in temp dir
                $is_in_temp = file_exists($temp_dir.'/'.$name);
                $temp =  !$is_in_temp
                    ? Upload::save($file,$name,$temp_dir)
                    : true;
                    
                if ($temp) {
                    $json_object = json_decode($this->post['directory']); 
                    $index = 0;
                    foreach ($json_object as $object) {
                        $remove_temp = $index >= count($json_object) ? true : false; 
                        $return = ImageLibrary::factory(array(
                                'temp_dir'       => $temp_dir,
                                'resize'         => empty($object->resize) ? false : $object->resize,
                                'resize_width'   => empty($object->width) ? 0 : $object->width,
                                'resize_height'  => empty($object->height) ? 0 : $object->height,
                                'file_name'      => $name,
                                'dest_dir'       => empty($object->location) ? null : $object->location,
                                'owner'          => $this->site->user->profile->is_admin
                            ))->mega_upload($remove_temp);
                        $index++;
                    }
                } else {
                    $return = __('upload_error',array('%message',''));
                }
                
            }
        }
        $this->ajax = $return;
    }	
	
}
   

?>