<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (Events Management)
 * @Module      Events 
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Event extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('title')->from('events')->where('id = '.$id)->execute()->current();
        return empty($check->title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'events "'.$check->title.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_event($execution = TRUE){
        $events = Setup::join_histories('events')
                    ->order_by('start_date','desc')
                    ->order_by('end_date','desc');                     
        return $execution === true ? $events->execution() : $events;
    }
    
    /**
     * @param
     */
    public function recent_event($limit = 5) {
        return $this->limit_event(false)->limit($limit)
                    ->order_by('start_date','asc')
                    ->order_by('end_date','asc')
                    ->execute();
    }
    
   
    /**
     * @var mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('events');
        
        if ($get_params[0] == 'field') {
            $field_name = "events.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
}
?>