<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Image Library Manage Class Controller
 * @Module      media Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_MediaLibrary_Image extends Controller_Space_Cms {
    protected $lib;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'image_library';
        $this->lib = ImageLibrary::factory();
    }
    
    
    public function action_index() {   
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'libraryimage',
                    'items_per_page' => 20,
                    'condition'
                ));    
            $this->condition();                             
            Paging::$init->compile();
            
            $this->meta('title',__('image_library'))
                 ->styles($this->site->system_js.'party3d/uploadify3/css/uploadify','screen,projection')
                 ->styles($this->site->system_js.'party3d/uploadify3/css/modify','screen,projection')
                 ->scripts($this->site->system_js.'party3d/uploadify3/scripts/uploadify')
                 
                 ->set('title',__('image_library'))
                 ->set(
                    'content',$this->html('image-libary')
                        ->set('lib',$this->lib))
                 ->render();    
        }
    }
    
    protected function condition() {
        
    }
    
}


?>