<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Installer
 * @Module      Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 
 

return array (
    'configuration' => '
        {
            "media_libraries" : {
                    "id" : {
                            "type" : "int",                            
                            "primary" : true,
                            "increment" : true
                        },
                    "type" : {
                            "type" : "char",
                            "length" : 20       
                        },
                    "file_name" : {
                            "type" : "varchar",
                            "length" : 250,
                            "notnull" : true
                        }                        
                },
            "media_positions" : {
                    "id" : { 
                            "type" : "int", 
                            "primary" : true, 
                            "increment" : true 
                        },
                    "label" : {
                            "type" : "char",
                            "length" : 15,
                            "form" : 
                                {
                                    "banner_position" : 
                                        {
                                            "label" : "title",
                                            "class" : "required title",
                                            "name" : "name"
                                        }
                                }
                        },
                    "width" : {
                            "type" : "smallint",
                            "form" : 
                                {
                                    "banner_position" : 
                                        {
                                            "label" : "width",
                                            "class" : "positiveinteger"
                                        }
                                }
                        },
                    "height" : {
                            "type" : "smallint",
                            "form" : 
                                {
                                    "banner_position" : 
                                        {
                                            "label" : "height",
                                            "class" : "positiveinteger"
                                        }
                                }
                        }
                },
            "media_applications" : {
                    "table" : {
                            "type" : "varchar",
                            "length" : 250, 
                            "primary" : true
                        },
                    "source_id" : {
                            "type" : "int", 
                            "primary" : true
                        },
                    "media_library_id" : {
                            "type" : "int",
                            "primary" : true
                        },
                    "media_position_id" : {
                            "type" : "int"
                        },
                    "ordering" : {
                            "type" : "int"
                        },
                    "title" : {
                            "type" : "varchar",
                            "length" : 250,
                            "form" : {
                                    "banner" : {
                                            "type": "text",
                                            "name" : "banner_title"
                                        }
                                }
                        },
                    "permalink" : {
                            "type" : "varchar",
                            "length" : 500,
                            "form" : {
                                    "banner" : {
                                            "type": "text",
                                            "name" : "banner_permalink",
                                            "class" : "url"
                                        }
                                }
                        }
                }
        }       
    ',  
    'mandatory' => ' 
        {
            "media_positions" :
                [
                    {
                        "id" : "1",
                        "label" : "Top",
                        "width" : 800,
                        "height" : 150
                    },
                    {
                        "id" : "2",
                        "label" : "Left",
                        "width" : 80,
                        "height" : 65
                    }
                ],
            "modules" : 
                [
                    {
                        "id" : "medialibrary",
                        "label" : "medialibrary",
                        "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`"
                    }
                ],
            "module_menus" :
                [
                    {
                        "id" : "image_library",
                        "module_id" : "medialibrary",
                        "parent_id" : 0,
                        "label" : "image_library",
                        "permalink" : "image",
                        "ordering" : 1
                    },
                    {
                        "id" : "banner_position",
                        "module_id" : "medialibrary",
                        "parent_id" : 0,
                        "label" : "banner_position",
                        "permalink" : "banner-position",
                        "ordering" : 2
                    }
                ],
            "permissions" : 
                [
                    {
                        "module_id" : "medialibrary",
                        "action" : "manage_image_library",
                        "label" : "manage_image_library"
                    },
                    {
                        "module_id" : "medialibrary",
                        "action" : "manage_banner_position",
                        "label" : "manage_banner_position"
                    }
                ],
            "module_menu_permissions" : 
                [
                    {
                        "module_menu_id" : "image_library",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'medialibrary\' AND `action` = \'manage_image_library\'"
                    },
                    {
                        "module_menu_id" : "banner_position",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'medialibrary\' AND `action` = \'manage_banner_position\'"
                    }
                ]
        }
    '
);
?>