<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    Welcome Controller
 * @Module      ~
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
 * */
class Controller_Site_Order_Order extends Controller_Space_Site {

    protected $site;
    protected $permalink;
    
    public function before() {  
       parent::before();     
       $this->site->menu->id = Model::factory('menu')->menu_id('how-to-order');       
       $this->site->menu->active = 'how-to-order';
       $this->permalink = $this->request->param('permalink');
       
       /*** Banner ***/
       $this->banner = Widget::$instance->load('page-banner')
                                ->set('table','site_menus')
                                ->set('source_id',$this->site->menu->id)
                                ->set('position', 'Page Banner');
        
       $this->site->menu->title = Model::factory('order')->get_parent_menu_title('how-to-order');
       
       $current_page = $this->permalink;
       
       $current_active = ($current_page=='') ? 'inquiry-form' : $current_page;
          
                     
       /*** Left Content ***/
       $this->left_content = View::factory('general/left-content')
                ->set('order_left', true)
                ->set('email_widget', true)
                ->set('current_active', $current_active);
       
       /*** attention ***/
       $this->attention = Model::factory('attention')->get_all_active_attentions();
       
       /*** industry ***/
       $this->industry = Model::factory('industry')->get_all_active_industries();
       
       /*** country ***/
       $this->country = Model::factory('country')->get_all_active_countries();
    }
    
    public function action_index() {
        $permalink = $this->permalink;
        $link = str_replace('-', '_', $permalink);
        $return  = "action_$link";
        return ($permalink==''||$permalink=='inquiry-form') ? $this->action_inquiry() : $this->$return();
    }

    /*
     * 
     */
    public function action_inquiry() {        
                
        $right_content = View::factory('html/site/order/right-content')
                ->set('attention', $this->attention)
                ->set('industry', $this->industry)
                ->set('country', $this->country);
       
        $this->set('title', 'How to Order | ' . $this->site->meta->title)
             ->meta('title', 'How to Order | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
        
    
    /*
     * return success send email
     */
    public function action_thankyou(){
        /*** send $news_detail to be constructed at news detail view ** */
        $right_content = View::factory('html/site/order/right-content')
                ->set('message', 'success');

        $this->set('title', 'How to Order | ' . $this->site->meta->title)
             ->meta('title', 'How to Order | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    /*
     * return error send email
     */
    public function action_failed_send_email(){
        /*** send $news_detail to be constructed at news detail view ** */
        $right_content = View::factory('html/site/order/right-content')
                ->set('message', 'failed');

        $this->set('title', 'How to Order | ' . $this->site->meta->title)
             ->meta('title', 'How to Order | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    
}

// End Welcome
