<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Module Package Installation
 * @Module      Order
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => 
        '
            {
                "attentions" :
                    {
                        "id" :
                            {
                                "type" : "int",                            
                                "primary" : true,
                                "increment" : true
                            },
                        "title" :
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "attention" :
                                            {
                                                "type" : "text",
                                                "label" : "Title",
                                                "name" : "title",
                                                "class" : "title required"
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "text",
                                "multilang" : false,
                                "form" :
                                    {
                                        "attention" :
                                            {
                                                "label" : "description",
                                                "type" : "textarea",
                                                "class" : "intro"
                                            }
                                    }
                            },
                        "receiver" : 
                            {
                                "type" : "text",
                                "form" :
                                    {
                                        "attention" :
                                            {
                                                "label" : "Receiver",
                                                "type" : "textarea",
                                                 "rows" : "2",
                                                 "cols" : "50"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "attention" :
                                            {
                                                "label" : "Status",
                                                "order" : 2
                                            }
                                    }
                            }
                    },
                "industries" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "industry" :
                                            {
                                                "label" : "Title",
                                                "class" : "title required"
                                            }
                                    }                                
                            },
                        "industry_code" : 
                            {
                                "type" : "varchar",
                                "length" : 10,
                                "form" :
                                    {
                                        "industry" :
                                            {
                                                "label" : "industry_code"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "industry" :
                                            {
                                                "label" : "Status"
                                            }
                                    }
                            }
                    },
                "countries" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "country" :
                                            {
                                                "label" : "Title",
                                                "class" : "title required"
                                            }
                                    }                                
                            },
                        "country_code" : 
                            {
                                "type" : "varchar",
                                "length" : 10,
                                "form" :
                                    {
                                        "country" :
                                            {
                                                "label" : "country_code"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "country" :
                                            {
                                                "label" : "Status"
                                            }
                                    }
                            }
                    },
                 "inquiry_logs" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250                              
                            },
                        "name" : 
                            {
                                "type" : "varchar",
                                "length" : 100
                            },
                        "phone" : 
                            {
                                "type" : "varchar",
                                "length" : 20
                            },
                        "fax" : 
                            {
                                "type" : "varchar",
                                "length" : 20
                            },
                        "email" : 
                            {
                                "type" : "varchar",
                                "length" : 100
                            },
                        "company" : 
                            {
                                "type" : "varchar",
                                "length" : 100
                            },
                        "industry" : 
                            {
                                "type" : "varchar",
                                "length" : 10
                            },
                        "country" : 
                            {
                                "type" : "varchar",
                                "length" : 10
                            },
                        "attention" : 
                            {
                                "type" : "varchar",
                                "length" : 100
                            },
                        "message" : 
                            {
                                "type" : "text"
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "read,unread",
                                "default" : "unread"
                            }
                    }
            }
        ',
    'alter_configuration' => 
        '
            {
            
            }
                
        ',
    'mandatory' => 
        '
            {
                "modules" : 
                    [
                        {
                            "id" : "order",
                            "label" : "order",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                            "is_system" : 0
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "order",
                            "action" : "create_attention",
                            "label" : "create_attention"
                        },
                        {
                            "module_id" : "order",
                            "action" : "edit_attention",
                            "label" : "edit_attention"
                        },
                        {
                            "module_id" : "order",
                            "action" : "delete_attention",
                            "label" : "delete_attention"
                        },
                        {
                            "module_id" : "order",
                            "action" : "view_attention",
                            "label" : "view_attention"
                        },
                        {
                            "module_id" : "order",
                            "action" : "create_industry",
                            "label" : "create_industry"
                        },
                        {
                            "module_id" : "order",
                            "action" : "edit_industry",
                            "label" : "edit_industry"
                        },
                        {
                            "module_id" : "order",
                            "action" : "delete_industry",
                            "label" : "delete_industry"
                        },
                        {
                            "module_id" : "order",
                            "action" : "view_industry",
                            "label" : "view_industry"
                        },
                        {
                            "module_id" : "order",
                            "action" : "create_country",
                            "label" : "create_country"
                        },
                        {
                            "module_id" : "order",
                            "action" : "edit_country",
                            "label" : "edit_country"
                        },
                        {
                            "module_id" : "order",
                            "action" : "delete_country",
                            "label" : "delete_country"
                        },
                        {
                            "module_id" : "order",
                            "action" : "view_country",
                            "label" : "view_country"
                        },
                        {
                            "module_id" : "order",
                            "action" : "edit_inquiry",
                            "label" : "edit_inquiry"
                        },
                        {
                            "module_id" : "order",
                            "action" : "delete_inquiry",
                            "label" : "delete_inquiry"
                        },
                        {
                            "module_id" : "order",
                            "action" : "view_inquiry",
                            "label" : "view_inquiry"
                        }
                    ],
                "module_menus" : 
                    [
                        {
                            "id" : "order_1",
                            "module_id" : "order",
                            "parent_id" : 0,
                            "label" : "attention_list",
                            "permalink" : "attention/manage",
                            "ordering" : 1
                        },
                        {
                            "id" : "order_2",
                            "module_id" : "order",
                            "parent_id" : 0,
                            "label" : "industry_list",
                            "permalink" : "industry/manage",
                            "ordering" : 2
                        },
                        {
                            "id" : "order_3",
                            "module_id" : "order",
                            "parent_id" : 0,
                            "label" : "country_list",
                            "permalink" : "country/manage",
                            "ordering" : 3
                        },
                        {
                            "id" : "order_4",
                            "module_id" : "order",
                            "parent_id" : 0,
                            "label" : "inquiry_list",
                            "permalink" : "inquiry/manage",
                            "ordering" : 4
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "order_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'create_attention\'"
                        },
                        {
                            "module_menu_id" : "order_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'edit_attention\'"
                        },
                        {
                            "module_menu_id" : "order_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'delete_attention\'"
                        },
                        {
                            "module_menu_id" : "order_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'view_attention\'"
                        },
                        {
                            "module_menu_id" : "order_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'create_industry\'"
                        },
                        {
                            "module_menu_id" : "order_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'edit_industry\'"
                        },
                        {
                            "module_menu_id" : "order_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'delete_industry\'"
                        },
                        {
                            "module_menu_id" : "order_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'view_industry\'"
                        },
                        {
                            "module_menu_id" : "order_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'create_country\'"
                        },
                        {
                            "module_menu_id" : "order_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'edit_country\'"
                        },
                        {
                            "module_menu_id" : "order_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'delete_country\'"
                        },
                        {
                            "module_menu_id" : "order_3",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'view_country\'"
                        },
                        {
                            "module_menu_id" : "order_4",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'create_inquiry\'"
                        },
                        {
                            "module_menu_id" : "order_4",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'delete_inquiry\'"
                        },
                        {
                            "module_menu_id" : "order_4",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'order\' AND `action` = \'view_inquiry\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "order_1",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "order_2",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "order_3",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "order_4",
                            "position" : "left"
                        }
                    ],
                "site_menus" :
                    [
                        {
                            "is_system" : 1,
                            "parent_id" : 0,
                            "menu_title" : "Order",
                            "permalink" : "order",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `site_menus`"     
                        }
                    ],
                "site_menu_position_applications" :
                    [
                        {
                            "site_menu_id" : "SELECT `id` FROM `site_menus` WHERE `menu_title` = \'Order\'",
                            "site_menu_position_id" : 1
                        }
                    ]
            }
        '
);