<?php
defined( 'SYSPATH' ) or die( 'No direct access allowed.' ) ;

/**
 * @author Wulung Pambuko M.Kom.
 * @copyright PT Web Architect Technology (WEBARQ) 2012
 */

return array( 
    'configuration' => '
            {
                "profiles" : 
                {
                    "id" : {
                            "type" : "tinyint",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "name" : {
                            "type" : "varchar", 
                            "length" : 64
                        },
                    "street" : {
                            "type" : "varchar",
                            "length" : 128
                        },
                    "state" : {
                            "type" : "varchar",
                            "length" : 16
                        },
                    "country" : {
                            "type" : "varchar",
                            "length" : 16
                        },
                    "postcode" : {
                            "type" : "smallint",
                            "unsigned" : true 
                        }
                }
            }
        '
    , 
    'mandatory' => '
            {
                "modules" : 
                    [
                        {
                            "id" : "profile",
                            "label" : "profile", 
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`"
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "profile",
                            "action" : "add",
                            "label" : "add_profile"
                        },
                        {
                            "module_id" : "profile",
                            "action" : "modify",
                            "label" : "modify_profile"
                        },
                        {
                            "module_id" : "profile",
                            "action" : "delete",
                            "label" : "delete_profile"
                        },
                        {
                            "module_id" : "profile",
                            "action" : "view",
                            "label" : "view_profile"
                        }
                    ],
                "module_menus" :
                    [
                        {
                            "id" : "profile_1",
                            "module_id" : "profile",
                            "parent_id" : 0,
                            "label" : "profile",
                            "permalink" : "list",
                            "ordering" : 1
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "profile_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'profile\' AND `action` = \'add_profile\'"
                        },
                        {
                            "module_menu_id" : "profile_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'profile\' AND `action` = \'modify_profile\'"
                        },
                        {
                            "module_menu_id" : "profile_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'profile\' AND `action` = \'delete_profile\'"
                        },
                        {
                            "module_menu_id" : "profile_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'profile\' AND `action` = \'view_profile\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "profile_1",
                            "position" : "left"
                        }
                    ]
            }
        '
) ;
?>
