<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (User)
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_User extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'register_user') {
        $check = $this->select(array(DB::expr("CONCAT(first_name,' ',last_name)"),'label'))->from('user_details')->where('user_id = '.$id)->execute();
        return empty($check[0]->label) 
            ? __('unknown') 
            : __($action,array(
                    '%user' => $check[0]->label
                ));
    }       
       
    /**
     * @var mixed params
     */
    public function get_user() {
        return $this->select(
                            array(DB::expr("CONCAT(first_name,' ',last_name)"), 'full_name'),
                            'u.*',
                            'd.first_name',
                            'd.last_name',
                            'd.sex',
                            'd.address',
                            'd.phone',
                            'd.avatar',                            
                            'r.is_admin',
                            array('r.label','role_name')
                        )
                ->from(array('users','u'))
                ->join(array('roles','r'))->on("u.role_id = r.id")
                ->join(array('user_details','d'))->on("u.id = d.user_id");
    }
   
    /**
     * @var mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = $this->get_user();
        
        if ($get_params[0] == 'session') {
            $querying->join(array('user_sessions','s'),'RIGHT')->on("u.id = s.user_id")
                     ->where("s.session = $get_params[1]")
                     ->and_where("s.logout IS NULL");
        } elseif ($get_params[0] == 'login') {
            $querying->where("u.username = $get_params[1]")
                     ->and_where("u.password = $get_params[2]")
                     ->and_where('u.status = active');
        } elseif ($get_params[0] == 'field') {
            $field_name = "u.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /**
     * @param boolean execute query data or return object
     */ 
    
    public function limit_user($execution = TRUE){
        $user = $this->get_user()->order_by('u.id','asc');
        
        return $execution === true ? $user->execute() : $user;
    }
}
?>